/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.communications.tcpip;

import com.valhalanetworks.utils.communications.Transporter;
import com.valhalanetworks.utils.communications.utils.SyncroBuffer;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIpServerConnectionManager
extends Thread
implements Transporter {
    @GuardedBy(value="this")
    private DataInputStream is;
    @GuardedBy(value="this")
    private DataOutputStream os;
    private Socket socket = null;
    private String ConectionID;
    private boolean OpenConnection = false;
    private boolean Runned = false;
    private boolean IsNew;
    private boolean StartCalled = false;
    private boolean StopCalled = false;
    private long OpenTime = System.currentTimeMillis();
    @GuardedBy(value="this")
    private SyncroBuffer Buffer;
    private int ReceiveBufferSize;
    private int SendBufferSize;
    private boolean KeepAlive;
    private int TrafficClass;
    private boolean TcpNoDelay;
    private LoggerManager Bitacora;
    public static final int IPTOS_LOWCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;
    public static final int ERROR_UNKNOWHOST = 1;
    public static final int ERROR_IO = 2;
    public static final int ERROR_SENDDATA = 3;
    public static final int ERROR_STARTNOTCALLED = 4;
    public static final int ERROR_CONNECTIONRUNNED = 5;
    public static final int ERROR_STOPNOTCALLED = 6;
    public static final int ERROR_INTERFACE = 7;

    public TcpIpServerConnectionManager(Socket socket) {
        super("TCP/IP Connection Manager to " + socket.getInetAddress().getHostName() + " at " + new Timestamp(System.currentTimeMillis()).toString());
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        this.socket = socket;
        long Hash = this.DJBHash(socket.getInetAddress().getHostName() + new Timestamp(this.OpenTime).toString() + this.convertToHex(this.long2byte(Aleatorio.nextLong())));
        this.ConectionID = this.convertToHex(this.long2byte(Hash));
        this.IsNew = true;
        this.ReceiveBufferSize = 8192;
        this.SendBufferSize = 8192;
        this.KeepAlive = false;
        this.TrafficClass = 2;
        this.TcpNoDelay = false;
        this.Bitacora = null;
    }

    public void setBitacora(LoggerManager Bitacora) {
        this.Bitacora = Bitacora;
    }

    public int getTrafficClass() throws UtilsException {
        if (this.socket != null) {
            try {
                this.TrafficClass = this.socket.getTrafficClass();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Traffic Class the socket", 7);
            }
        }
        return this.TrafficClass;
    }

    public void setTrafficClass(int TrafficClass) throws UtilsException {
        if (TrafficClass >= 0 && TrafficClass <= 255) {
            if (this.socket != null) {
                try {
                    this.TrafficClass = TrafficClass;
                    this.socket.setTrafficClass(this.TrafficClass);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Traffic Class to " + Integer.toString(TrafficClass), 7);
                }
            } else {
                this.TrafficClass = TrafficClass;
            }
        }
    }

    public void setReceiveBufferSize(int ReceiveBufferSize) throws UtilsException {
        if (ReceiveBufferSize > 0) {
            if (this.socket != null) {
                try {
                    this.ReceiveBufferSize = ReceiveBufferSize;
                    this.socket.setReceiveBufferSize(this.ReceiveBufferSize);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Recive Buffer Size to " + Integer.toString(ReceiveBufferSize) + " kbps ", 7);
                }
            } else {
                this.ReceiveBufferSize = ReceiveBufferSize;
            }
        }
    }

    public void setSendBufferSize(int SendBufferSize) throws UtilsException {
        if (SendBufferSize > 0) {
            if (this.socket != null) {
                try {
                    this.SendBufferSize = SendBufferSize;
                    this.socket.setReceiveBufferSize(this.SendBufferSize);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Send Buffer Size to " + Integer.toString(SendBufferSize) + " kbps ", 7);
                }
            } else {
                this.SendBufferSize = SendBufferSize;
            }
        }
    }

    public void setKeepAlive(boolean KeepAlive) throws UtilsException {
        if (this.socket != null) {
            try {
                this.KeepAlive = KeepAlive;
                this.socket.setKeepAlive(this.KeepAlive);
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't set Socket KeepAlive", 7);
            }
        } else {
            this.KeepAlive = KeepAlive;
        }
    }

    public int getReceiveBufferSize() throws UtilsException {
        if (this.socket != null) {
            try {
                this.ReceiveBufferSize = this.socket.getReceiveBufferSize();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Revice Buffer Size at the socket", 7);
            }
        }
        return this.ReceiveBufferSize;
    }

    public int getSendBufferSize() throws UtilsException {
        if (this.socket != null) {
            try {
                this.SendBufferSize = this.socket.getSendBufferSize();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Send Buffer Size at the socket", 7);
            }
        }
        return this.SendBufferSize;
    }

    public boolean isKeepAlive() throws UtilsException {
        if (this.socket != null) {
            try {
                this.KeepAlive = this.socket.getKeepAlive();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Keep Alive status at the socket", 7);
            }
        }
        return this.KeepAlive;
    }

    public void setTCPNoDelay(boolean TcpNoDelay) throws UtilsException {
        if (this.socket != null) {
            try {
                this.TcpNoDelay = TcpNoDelay;
                this.socket.setTcpNoDelay(this.TcpNoDelay);
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't set Socket TcpNoDelay", 7);
            }
        } else {
            this.TcpNoDelay = TcpNoDelay;
        }
    }

    public boolean isTCPNoDelay() throws UtilsException {
        if (this.socket != null) {
            try {
                this.TcpNoDelay = this.socket.getTcpNoDelay();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the TcpNoDelay status at the socket", 7);
            }
        }
        return this.TcpNoDelay;
    }

    public String getConnectionID() {
        return this.ConectionID;
    }

    public String getClient() {
        return this.socket.getInetAddress().getHostName();
    }

    public long getConnetionTime() {
        long Timer = System.currentTimeMillis() - this.OpenTime;
        return Timer;
    }

    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public synchronized void Open() throws UtilsException {
        if (!this.Runned && this.StartCalled) {
            this.Buffer = new SyncroBuffer();
            try {
                this.socket.setKeepAlive(this.KeepAlive);
                this.socket.setTcpNoDelay(this.TcpNoDelay);
                this.socket.setReceiveBufferSize(this.ReceiveBufferSize);
                this.socket.setSendBufferSize(this.SendBufferSize);
                this.socket.setTrafficClass(this.TrafficClass);
                this.is = new DataInputStream(this.socket.getInputStream());
                this.os = new DataOutputStream(this.socket.getOutputStream());
            }
            catch (UnknownHostException ex) {
                throw new UtilsException("ERROR: Host " + this.socket.getInetAddress().getHostName() + " Desconocido ", 1);
            }
            catch (IOException ex) {
                throw new UtilsException("ERROR: Conexion con el Host " + this.socket.getInetAddress().getHostName() + " " + ex.getLocalizedMessage(), 2);
            }
            boolean ChangeThead = true;
            try {
                this.checkAccess();
            }
            catch (SecurityException ex) {
                ChangeThead = false;
            }
            if (ChangeThead) {
                int Priority = this.getPriority() - 2;
                if (Priority < 1) {
                    Priority = 1;
                }
                this.setPriority(Priority);
            }
        } else {
            if (!this.StartCalled) {
                throw new UtilsException("ERROR: Method Open called by user and not by Start ", 4);
            }
            throw new UtilsException("ERROR: Connection manager runned ", 5);
        }
    }

    @Override
    public synchronized void Close() throws UtilsException {
        if (this.StopCalled) {
            try {
                this.is.close();
                this.os.close();
                this.socket.close();
            }
            catch (IOException ex) {
                throw new UtilsException("ERROR: Al cerrar conexion con el Host " + this.socket.getInetAddress().getHostName() + " " + ex.getLocalizedMessage(), 2);
            }
        } else {
            throw new UtilsException("ERROR: Method Close called by user and not by Stop ", 6);
        }
    }

    @Override
    public synchronized void Send(byte[] Datos) throws UtilsException {
        try {
            this.os.write(Datos, 0, Datos.length);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: Error al enviar datos al Host " + this.socket.getInetAddress().getHostName() + " " + ex.getLocalizedMessage(), 3);
        }
    }

    @Override
    public synchronized byte[] Recive() {
        byte[] Datos = this.Buffer.getall();
        return Datos;
    }

    @Override
    public synchronized boolean DataAvailable() {
        boolean Salida = false;
        if (this.Buffer.length() > 0) {
            Salida = true;
        }
        return Salida;
    }

    @Override
    public int TransporterTypeID() {
        return 1;
    }

    public synchronized boolean isOpen() {
        return this.OpenConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this.Runned) {
            try {
                this.StartCalled = true;
                this.Open();
                this.Runned = true;
                TcpIpServerConnectionManager tcpIpServerConnectionManager = this;
                synchronized (tcpIpServerConnectionManager) {
                    this.OpenConnection = true;
                }
                super.start();
            }
            catch (UtilsException ex) {
                if (this.Bitacora == null) {
                    Logger.getLogger(TcpIpServerConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.Bitacora.LogMessage(2, 5, TcpIpServerConnectionManager.class.getName(), "ERROR: Thread Start Fail");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop() {
        TcpIpServerConnectionManager tcpIpServerConnectionManager = this;
        synchronized (tcpIpServerConnectionManager) {
            this.OpenConnection = false;
        }
        try {
            this.StopCalled = true;
            this.Close();
        }
        catch (UtilsException ex) {
            if (this.Bitacora == null) {
                Logger.getLogger(TcpIpServerConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.Bitacora.LogMessage(2, 5, TcpIpServerConnectionManager.class.getName(), "ERROR: Thread Stop Fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        while (this.OpenConnection) {
            try {
                int NumBytes = 0;
                do {
                    TcpIpServerConnectionManager tcpIpServerConnectionManager = this;
                    synchronized (tcpIpServerConnectionManager) {
                        if (this.is != null) {
                            NumBytes = this.is.available();
                        }
                    }
                    if (NumBytes >= 1 || !this.OpenConnection) continue;
                    try {
                        TcpIpServerConnectionManager.sleep(100 + Math.abs(Aleatorio.nextInt()) % 400);
                    }
                    catch (InterruptedException ex) {
                        if (this.Bitacora == null) {
                            Logger.getLogger(TcpIpServerConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        this.Bitacora.LogMessage(2, 5, TcpIpServerConnectionManager.class.getName(), "ERROR: Thread Sleeper Fail");
                    }
                } while (NumBytes < 1 && this.OpenConnection);
                if (!this.OpenConnection) continue;
                byte[] BufferByte = new byte[NumBytes];
                TcpIpServerConnectionManager ex = this;
                synchronized (ex) {
                    this.is.read(BufferByte, 0, NumBytes);
                    this.Buffer.put(BufferByte);
                }
            }
            catch (IOException ex) {
                if (this.Bitacora == null) {
                    Logger.getLogger(TcpIpServerConnectionManager.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                this.Bitacora.LogMessage(2, 5, TcpIpServerConnectionManager.class.getName(), "ERROR: Thread Run Fail");
            }
        }
    }

    private long DJBHash(String str) {
        long hash = 5381L;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash << 5) + hash + (long)str.charAt(i);
        }
        return hash;
    }

    private String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    private byte[] long2byte(long Entrada) {
        int base = 8;
        int multi = 64 / base;
        byte[] Salida = new byte[multi];
        for (int j = 0; j < multi; ++j) {
            long temp = Entrada << base * j;
            Salida[j] = (byte)(temp >>> 64 - base);
        }
        return Salida;
    }

    protected boolean isNew() {
        return this.IsNew;
    }

    protected void ClearNewFlag() {
        this.IsNew = false;
    }

    @Override
    public int getMTU() throws UtilsException {
        int MTU = -1;
        if (this.socket.isBound()) {
            NetworkInterface Interfaz;
            try {
                Interfaz = NetworkInterface.getByInetAddress(this.socket.getLocalAddress());
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Al obtener la interface:" + ex.getLocalizedMessage(), 7);
            }
            try {
                MTU = Interfaz.getMTU();
                MTU -= 40;
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Al obtener el MTU de la interface:" + ex.getLocalizedMessage(), 7);
            }
        }
        return MTU;
    }
}

