/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.cryptography.aes.utils;

import com.valhalanetworks.cryptography.aes.CuaimaAES;
import com.valhalanetworks.cryptography.digest.BaseHash;
import com.valhalanetworks.cryptography.digest.CRC32;
import com.valhalanetworks.cryptography.digest.CRC64;
import com.valhalanetworks.cryptography.digest.Has160;
import com.valhalanetworks.cryptography.digest.Haval;
import com.valhalanetworks.cryptography.digest.MD2;
import com.valhalanetworks.cryptography.digest.MD4;
import com.valhalanetworks.cryptography.digest.MD5;
import com.valhalanetworks.cryptography.digest.RipeMD128;
import com.valhalanetworks.cryptography.digest.RipeMD160;
import com.valhalanetworks.cryptography.digest.Sha0;
import com.valhalanetworks.cryptography.digest.Sha160;
import com.valhalanetworks.cryptography.digest.Sha224;
import com.valhalanetworks.cryptography.digest.Sha256;
import com.valhalanetworks.cryptography.digest.Sha384;
import com.valhalanetworks.cryptography.digest.Sha512;
import com.valhalanetworks.cryptography.digest.Tiger;
import com.valhalanetworks.cryptography.digest.Tiger128;
import com.valhalanetworks.cryptography.digest.Tiger160;
import com.valhalanetworks.cryptography.digest.Tiger2;
import com.valhalanetworks.cryptography.digest.Whirlpool;
import com.valhalanetworks.cryptography.digest.Whirlpool2000;
import com.valhalanetworks.cryptography.digest.Whirlpool2003;
import com.valhalanetworks.cryptography.interfaces.CryptoFile;
import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.math.MathUtil;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import com.valhalanetworks.utils.vthreads.annotations.ThreadSafe;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafe
public class AESFile
implements CryptoFile,
Runnable {
    private LoggerManager Log;
    @GuardedBy(value="AES")
    private CuaimaAES AES;
    private int PasswdLength;
    private double HeadPos;
    @GuardedBy(value="this")
    private int BufferSize;
    @GuardedBy(value="this")
    private int Progress = 0;
    @GuardedBy(value="FileParameters")
    private FileOperationParameters FileParameters;
    private Thread Ejecutando = null;
    private boolean Coding = true;
    @GuardedBy(value="this")
    int ErrorCode = 0;
    private static final short VERSION = 3;
    private static final int HASHMASK = 31;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private strictfp void CalcHeadPos(String Password) {
        long Temp = 0L;
        for (int i = 0; i < Password.length(); ++i) {
            Temp += (long)Password.charAt(i);
        }
        this.HeadPos = Temp;
        this.HeadPos /= 100.0;
        Temp = (long)this.HeadPos;
        this.HeadPos -= (double)Temp;
        try {
            this.HeadPos = MathUtil.roundToDecimals(this.HeadPos, 2);
        }
        catch (UtilsException ex) {
            AESFile aESFile = this;
            synchronized (aESFile) {
                this.ErrorCode = 15;
            }
            if (this.Log != null) {
                this.Log.LogMessage(2, 5, AESFile.class.getName(), ex.getLocalizedMessage());
            }
            Logger.getLogger(AESFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.HeadPos > 0.8) {
            this.HeadPos = 0.8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AESFile(LoggerManager Log) {
        this.PasswdLength = -1;
        AESFile aESFile = this;
        synchronized (aESFile) {
            this.BufferSize = 0x3200000;
            this.AES = new CuaimaAES();
        }
        this.Log = Log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AESFile(String Password, LoggerManager Log) throws UtilsException {
        this.Log = Log;
        Object object = this;
        synchronized (object) {
            this.BufferSize = 0x3200000;
            this.AES = new CuaimaAES();
        }
        object = this.AES;
        synchronized (object) {
            if (this.AES.Password(Password) != 0) {
                this.PasswdLength = -1;
                AESFile aESFile = this;
                synchronized (aESFile) {
                    this.Progress = -1;
                }
                throw new UtilsException("ERROR: NO se pudo inicializar AESFile, falla al inicializar el Password", 4);
            }
            this.PasswdLength = Password.length();
            this.CalcHeadPos(Password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean Password(String Passw) throws UtilsException {
        boolean salida = false;
        this.PasswdLength = -1;
        if (this.AES != null) {
            CuaimaAES cuaimaAES = this.AES;
            synchronized (cuaimaAES) {
                if (this.AES.Password(Passw) != 0) {
                    AESFile aESFile = this;
                    synchronized (aESFile) {
                        this.Progress = -1;
                    }
                    throw new UtilsException("ERROR: NO se pudo inicializar la clave en AESFile", 4);
                }
                this.PasswdLength = Passw.length();
                this.CalcHeadPos(Passw);
                salida = true;
            }
        }
        return salida;
    }

    @Override
    public synchronized int getBufferSize() {
        return this.BufferSize;
    }

    @Override
    public synchronized void setBufferSize(int BufferSize) {
        this.BufferSize = BufferSize < 16 ? 16 : (int)(16.0 * Math.ceil((double)BufferSize / 16.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void PrivCodec() throws UtilsException {
        if (this.FileParameters != null) {
            FileManager Input = this.FileParameters.getInput();
            FileManager Output = this.FileParameters.getOutput();
            int Opciones = this.FileParameters.getOpciones();
            if (Input.getFileLength() > 0L) {
                if (this.PasswdLength > 0) {
                    if (Input.isFile()) {
                        byte[] InputBuffer;
                        Object ex3;
                        String OutputFileName;
                        long InputFileLength;
                        BaseHash Hash;
                        MersenneTwisterPlus Rand = new MersenneTwisterPlus();
                        int HashType = Opciones & 0x1F;
                        switch (HashType) {
                            case 1: {
                                Hash = new Whirlpool2003();
                                break;
                            }
                            case 2: {
                                Hash = new Whirlpool2000();
                                break;
                            }
                            case 3: {
                                Hash = new Whirlpool();
                                break;
                            }
                            case 4: {
                                Hash = new Sha0();
                                break;
                            }
                            case 5: {
                                Hash = new Sha160();
                                break;
                            }
                            case 6: {
                                Hash = new Sha224();
                                break;
                            }
                            case 7: {
                                Hash = new Sha256();
                                break;
                            }
                            case 8: {
                                Hash = new Sha384();
                                break;
                            }
                            case 9: {
                                Hash = new Sha512();
                                break;
                            }
                            case 10: {
                                Hash = new Tiger();
                                break;
                            }
                            case 11: {
                                Hash = new Tiger2();
                                break;
                            }
                            case 12: {
                                Hash = new Tiger128();
                                break;
                            }
                            case 13: {
                                Hash = new Tiger160();
                                break;
                            }
                            case 14: {
                                Hash = new RipeMD128();
                                break;
                            }
                            case 15: {
                                Hash = new RipeMD160();
                                break;
                            }
                            case 16: {
                                Hash = new MD2();
                                break;
                            }
                            case 17: {
                                Hash = new MD4();
                                break;
                            }
                            case 18: {
                                Hash = new MD5();
                                break;
                            }
                            case 19: {
                                Hash = new Haval(16);
                                break;
                            }
                            case 20: {
                                Hash = new Haval(20);
                                break;
                            }
                            case 21: {
                                Hash = new Haval(24);
                                break;
                            }
                            case 22: {
                                Hash = new Haval(28);
                                break;
                            }
                            case 23: {
                                Hash = new Haval(32);
                                break;
                            }
                            case 24: {
                                Hash = new Has160();
                                break;
                            }
                            case 25: {
                                Hash = new CRC32();
                                break;
                            }
                            case 26: {
                                Hash = new CRC64();
                                break;
                            }
                            case 0: {
                                Hash = null;
                                break;
                            }
                            default: {
                                Hash = new Whirlpool2003();
                            }
                        }
                        if (Hash != null) {
                            Hash.reset();
                        }
                        if ((InputFileLength = Input.getFileLength()) < 0L) {
                            InputFileLength = 0L;
                        }
                        String InputFileName = Input.getFileName();
                        String InputFilePath = Input.getFilePath();
                        String Separador = Input.getSeparador();
                        long k = (long)(8.0 * Math.ceil((double)InputFileName.length() / 8.0));
                        k /= 8L;
                        k = (long)(2.0 * Math.ceil((double)k / 2.0));
                        StringBuffer TempInputFileName = new StringBuffer(InputFileName);
                        int i = InputFileName.length();
                        while ((long)i < k * 8L) {
                            TempInputFileName.append((char)(97.0 + 25.0 * Rand.nextReal()));
                            ++i;
                        }
                        long[] Header = new long[8 + (int)k];
                        Header[0] = Rand.nextLong() << 32 | Converter.byte2long(new String("CAESSEAC").getBytes())[0] >>> 32;
                        Header[1] = Converter.byte2long(new String("CAESSEAC").getBytes())[0] << 32 | Rand.nextLong() >>> 32;
                        Header[2] = (long)InputFileName.length() | (long)Header.length << 32;
                        Header[3] = InputFileLength;
                        i = 0;
                        while ((long)i < k) {
                            Header[4 + i] = Converter.byte2long(TempInputFileName.substring(i * 8, (i + 1) * 8).getBytes())[0];
                            ++i;
                        }
                        Header[Header.length - 4] = Rand.nextLong();
                        Header[Header.length - 3] = Rand.nextLong() << 32;
                        int n = Header.length - 3;
                        Header[n] = Header[n] | (long)(HashType << 26);
                        int n2 = Header.length - 3;
                        Header[n2] = Header[n2] | 3L;
                        Header[Header.length - 2] = Rand.nextLong() << 32 | Converter.byte2long(new String("CAESSEAC").getBytes())[0] >>> 32;
                        Header[Header.length - 1] = Converter.byte2long(new String("CAESSEAC").getBytes())[0] << 32 | Rand.nextLong() >>> 32;
                        long OutputCodecFileLength = (long)Math.ceil((double)InputFileLength * 0.1);
                        if ((long)Header.length > OutputCodecFileLength) {
                            InputFileLength = 56 * Header.length;
                        }
                        if (Hash != null) {
                            OutputCodecFileLength = Hash.hashSize();
                            OutputCodecFileLength = (long)Math.ceil((double)(InputFileLength + OutputCodecFileLength) / 8.0);
                            OutputCodecFileLength = (long)(16.0 * Math.ceil((double)((long)Header.length + OutputCodecFileLength) / 16.0));
                        } else {
                            OutputCodecFileLength = (long)Math.ceil((double)InputFileLength / 8.0);
                            OutputCodecFileLength = (long)(16.0 * Math.ceil((double)((long)Header.length + OutputCodecFileLength) / 16.0));
                        }
                        long HPosc = (long)(this.HeadPos * (double)OutputCodecFileLength);
                        HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0));
                        if (Output == null) {
                            OutputFileName = new String(InputFilePath + Separador + Input.getFileBaseName() + ".caes");
                            Output = new FileManager(OutputFileName);
                        } else if (Output != null && Output.isDirectory()) {
                            OutputFileName = new String(Input.getFileBaseName() + ".caes");
                            Output = new FileManager(Output.getFilePath() + Output.getSeparador() + OutputFileName);
                        }
                        this.FileParameters.setOutput(Output);
                        if (Output.Exists() && !Output.Delete()) {
                            AESFile aESFile = this;
                            synchronized (aESFile) {
                                this.Progress = -1;
                            }
                            throw new UtilsException("ERROR: NO se pudo borrar el archivo de salida existente", 8);
                        }
                        try {
                            Output.Open(1);
                        }
                        catch (UtilsException ex2) {
                            AESFile aESFile = this;
                            synchronized (aESFile) {
                                this.Progress = -1;
                            }
                            throw new UtilsException("ERROR: NO se pudo crear el archivo " + Output.getAbsoluteFilePath(), 9);
                        }
                        try {
                            Input.Open(0);
                        }
                        catch (UtilsException ex3) {
                            AESFile aESFile = this;
                            synchronized (aESFile) {
                                this.Progress = -1;
                            }
                            throw new UtilsException("ERROR: NO se pudo abrir el archivo " + Input.getAbsoluteFilePath(), 5);
                        }
                        long[] CBuffer = new long[2];
                        for (i = 0; i < Header.length; i += 2) {
                            CBuffer[0] = Header[i];
                            CBuffer[1] = Header[i + 1];
                            byte[] Temp = Converter.long2byte(CBuffer);
                            ex3 = this.AES;
                            synchronized (ex3) {
                                Temp = this.AES.Encrypt(Temp);
                            }
                            CBuffer = Converter.byte2long(Temp);
                            Header[i] = CBuffer[0];
                            Header[i + 1] = CBuffer[1];
                        }
                        ex3 = this;
                        synchronized (ex3) {
                            InputBuffer = new byte[this.BufferSize];
                        }
                        byte[] SubInputBuffer = new byte[16];
                        long NumBytesReads = InputBuffer.length;
                        long NumBlockWrite = 0L;
                        boolean HeaderAdded = false;
                        while ((long)InputBuffer.length == NumBytesReads) {
                            long DTemp;
                            try {
                                NumBytesReads = Input.Read(InputBuffer);
                            }
                            catch (UtilsException ex4) {
                                AESFile aESFile = this;
                                synchronized (aESFile) {
                                    this.Progress = -1;
                                }
                                throw new UtilsException("ERROR: NO se puedo leer el archivo a codificar", 6);
                            }
                            if (NumBytesReads > 0L) {
                                if (Hash != null) {
                                    Hash.update(InputBuffer, 0, (int)NumBytesReads);
                                }
                                if (NumBytesReads < (long)InputBuffer.length) {
                                    DTemp = NumBytesReads;
                                    NumBytesReads = Hash != null ? (long)((int)(16.0 * Math.ceil((double)(NumBytesReads + (long)Hash.hashSize()) / 16.0))) : (long)((int)(16.0 * Math.ceil((double)NumBytesReads / 16.0)));
                                    if (NumBlockWrite + NumBytesReads / 8L != OutputCodecFileLength) {
                                        NumBytesReads = HeaderAdded ? (long)((int)(8L * (OutputCodecFileLength - NumBlockWrite))) : (long)((int)(8L * (OutputCodecFileLength - NumBlockWrite - (long)Header.length)));
                                    }
                                    InputBuffer = (byte[])ArrayUtils.resizeArray(InputBuffer, (int)NumBytesReads);
                                    if (Hash != null) {
                                        ArrayUtils.arrayCopy(Hash.digest(), 0, InputBuffer, (int)DTemp, Hash.hashSize());
                                        i = (int)(DTemp + (long)Hash.hashSize());
                                        while ((long)i < NumBytesReads) {
                                            InputBuffer[i] = Rand.nextByte();
                                            ++i;
                                        }
                                    } else {
                                        i = (int)DTemp;
                                        while ((long)i < NumBytesReads) {
                                            InputBuffer[i] = Rand.nextByte();
                                            ++i;
                                        }
                                    }
                                }
                                i = 0;
                                while ((long)i < NumBytesReads) {
                                    int j;
                                    for (j = 0; j < 16; ++j) {
                                        SubInputBuffer[j] = InputBuffer[i + j];
                                    }
                                    ex3 = this.AES;
                                    synchronized (ex3) {
                                        SubInputBuffer = this.AES.Encrypt(SubInputBuffer);
                                    }
                                    for (j = 0; j < 16; ++j) {
                                        InputBuffer[i + j] = SubInputBuffer[j];
                                    }
                                    i += 16;
                                }
                                if (NumBlockWrite <= HPosc && NumBlockWrite + NumBytesReads / 8L >= HPosc) {
                                    DTemp = (int)(8L * (HPosc - NumBlockWrite));
                                    try {
                                        Output.Write(InputBuffer, 0, (int)DTemp);
                                        Output.Write(Converter.long2byte(Header), 0, 8 * Header.length);
                                        Output.Write(InputBuffer, (int)DTemp, (int)(NumBytesReads - DTemp));
                                    }
                                    catch (UtilsException ex5) {
                                        AESFile aESFile = this;
                                        synchronized (aESFile) {
                                            this.Progress = -1;
                                        }
                                        throw new UtilsException("ERROR: NO se puede escribir en el archivo " + Output.getAbsoluteFilePath(), 10);
                                    }
                                    NumBlockWrite += NumBytesReads / 8L + (long)Header.length;
                                    HeaderAdded = true;
                                } else {
                                    try {
                                        Output.Write(InputBuffer, 0, (int)NumBytesReads);
                                    }
                                    catch (UtilsException ex6) {
                                        AESFile aESFile = this;
                                        synchronized (aESFile) {
                                            this.Progress = -1;
                                        }
                                        throw new UtilsException("ERROR: NO se puede escribir en el archivo " + Output.getAbsoluteFilePath(), 10);
                                    }
                                    NumBlockWrite += NumBytesReads / 8L;
                                }
                            }
                            if ((DTemp = NumBlockWrite * 100L / OutputCodecFileLength) == 100L) {
                                DTemp = 99L;
                            }
                            ex3 = this;
                            synchronized (ex3) {
                                this.Progress = (int)DTemp;
                            }
                        }
                        try {
                            Input.Close();
                        }
                        catch (UtilsException ex7) {
                            AESFile aESFile = this;
                            synchronized (aESFile) {
                                this.Progress = -1;
                            }
                            throw new UtilsException("ERROR: NO se puede cerrar el archivo " + Input.getAbsoluteFilePath(), 11);
                        }
                        try {
                            Output.Close();
                        }
                        catch (UtilsException ex8) {
                            AESFile aESFile = this;
                            synchronized (aESFile) {
                                this.Progress = -1;
                            }
                            throw new UtilsException("ERROR: NO se puede cerrar el archivo " + Output.getAbsoluteFilePath(), 12);
                        }
                    }
                    AESFile aESFile = this;
                    synchronized (aESFile) {
                        this.Progress = -1;
                    }
                    throw new UtilsException("ERROR: NO se puede identificar el tipo de archivo a codificar", 13);
                }
                AESFile aESFile = this;
                synchronized (aESFile) {
                    this.Progress = -1;
                }
                throw new UtilsException("ERROR: Clave NO definida para codificar archivo", 4);
            }
            AESFile aESFile = this;
            synchronized (aESFile) {
                this.Progress = -1;
            }
            throw new UtilsException("ERROR: Achivo de entrada tiene tama\u00f1o 0", 16);
        }
        AESFile aESFile = this;
        synchronized (aESFile) {
            this.Progress = -1;
        }
        throw new UtilsException("ERROR: Archivos y Parametros de Codificacion NO Definidos", 14);
        AESFile aESFile2 = this;
        synchronized (aESFile2) {
            this.Progress = 100;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void PrivDecodec() throws UtilsException {
        AESFile aESFile;
        block147: {
            BaseHash Hash;
            int HeaderLength;
            long OutputFileLength;
            Object ex3;
            int i;
            long NumBytesReads;
            byte[] InputBuffer;
            long HPosc;
            FileManager Output;
            FileManager Input;
            byte[] NewDigest;
            byte[] OrgDigest;
            block148: {
                block146: {
                    byte[] Temp;
                    boolean Resultado = false;
                    OrgDigest = null;
                    NewDigest = null;
                    if (this.FileParameters == null) {
                        AESFile aESFile2 = this;
                        synchronized (aESFile2) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: Archivos de Decodificacion NO Definidos", 14);
                        }
                    }
                    Input = this.FileParameters.getInput();
                    Output = this.FileParameters.getOutput();
                    if (Input.getFileLength() <= 0L) {
                        AESFile aESFile3 = this;
                        synchronized (aESFile3) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: Achivo de entrada tiene tama\u00f1o 0", 16);
                        }
                    }
                    if (this.PasswdLength <= 0) {
                        AESFile aESFile4 = this;
                        synchronized (aESFile4) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: Clave NO definida para codificar archivo", 4);
                        }
                    }
                    if (!Input.isFile()) break block146;
                    long InputCodecFileLength = (long)Math.ceil((double)Input.getFileLength() / 8.0);
                    String InputCodecFileName = Input.getFileName();
                    String InputCodecFilePath = Input.getFilePath();
                    String Separador = File.separator;
                    HPosc = (long)(this.HeadPos * (double)InputCodecFileLength);
                    HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0));
                    try {
                        Input.Open(0);
                    }
                    catch (UtilsException ex2) {
                        AESFile aESFile5 = this;
                        synchronized (aESFile5) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo abrir el archivo " + Input.getAbsoluteFilePath(), 5);
                        }
                    }
                    InputBuffer = new byte[32];
                    try {
                        Input.Skip(8L * HPosc);
                        NumBytesReads = Input.Read(InputBuffer);
                    }
                    catch (UtilsException ex3) {
                        AESFile aESFile6 = this;
                        synchronized (aESFile6) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                        }
                    }
                    if (NumBytesReads != 32L) {
                        AESFile ex3 = this;
                        synchronized (ex3) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                        }
                    }
                    long[] Header = Converter.byte2long(InputBuffer);
                    long[] DcBuffer = new long[2];
                    for (i = 0; i < Header.length; i += 2) {
                        DcBuffer[0] = Header[i];
                        DcBuffer[1] = Header[i + 1];
                        Temp = Converter.long2byte(DcBuffer);
                        ex3 = this.AES;
                        synchronized (ex3) {
                            Temp = this.AES.Decrypt(Temp);
                        }
                        DcBuffer = Converter.byte2long(Temp);
                        Header[i] = DcBuffer[0];
                        Header[i + 1] = DcBuffer[1];
                    }
                    long[] HTemp = new long[]{Header[0] << 32 | Header[1] >>> 32};
                    String HeaderDec = new String(Converter.long2byte(HTemp));
                    if (!HeaderDec.contentEquals(new StringBuffer("CAESSEAC"))) {
                        aESFile = this;
                        synchronized (aESFile) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo Decodificar el archivo " + Input.getAbsoluteFilePath(), 7);
                        }
                    }
                    OutputFileLength = Header[3];
                    if (OutputFileLength < 0L) {
                        OutputFileLength = 0L;
                    }
                    int OutputFileNameLength = (int)(Header[2] & 0xFFFFFFFFFFFFFFFFL);
                    HeaderLength = (int)(Header[2] >>> 32);
                    Header = (long[])ArrayUtils.resizeArray(Header, HeaderLength);
                    InputBuffer = new byte[8 * (HeaderLength - 4)];
                    try {
                        NumBytesReads = Input.Read(InputBuffer);
                    }
                    catch (UtilsException ex4) {
                        AESFile aESFile7 = this;
                        synchronized (aESFile7) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                        }
                    }
                    if (NumBytesReads != (long)(8 * (HeaderLength - 4))) {
                        ex3 = this;
                        synchronized (ex3) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                        }
                    }
                    HTemp = Converter.byte2long(InputBuffer);
                    DcBuffer = new long[2];
                    for (i = 0; i < HTemp.length; i += 2) {
                        DcBuffer[0] = HTemp[i];
                        DcBuffer[1] = HTemp[i + 1];
                        Temp = Converter.long2byte(DcBuffer);
                        ex3 = this.AES;
                        synchronized (ex3) {
                            Temp = this.AES.Decrypt(Temp);
                        }
                        DcBuffer = Converter.byte2long(Temp);
                        HTemp[i] = DcBuffer[0];
                        HTemp[i + 1] = DcBuffer[1];
                    }
                    for (i = 0; i < HTemp.length; ++i) {
                        Header[4 + i] = HTemp[i];
                    }
                    HTemp = new long[]{Header[HeaderLength - 2] << 32 | Header[HeaderLength - 1] >>> 32};
                    HeaderDec = new String(Converter.long2byte(HTemp));
                    if (!HeaderDec.contentEquals(new StringBuffer("CAESSEAC"))) {
                        aESFile = this;
                        synchronized (aESFile) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo Decodificar el archivo " + Input.getAbsoluteFilePath(), 7);
                        }
                    }
                    int Version = (int)(Header[Header.length - 3] & 0xFFL);
                    if (Version != 3) break block147;
                    int HashType = (int)(Header[Header.length - 3] >>> 26) & 0x1F;
                    switch (HashType) {
                        case 1: {
                            Hash = new Whirlpool2003();
                            break;
                        }
                        case 2: {
                            Hash = new Whirlpool2000();
                            break;
                        }
                        case 3: {
                            Hash = new Whirlpool();
                            break;
                        }
                        case 4: {
                            Hash = new Sha0();
                            break;
                        }
                        case 5: {
                            Hash = new Sha160();
                            break;
                        }
                        case 6: {
                            Hash = new Sha224();
                            break;
                        }
                        case 7: {
                            Hash = new Sha256();
                            break;
                        }
                        case 8: {
                            Hash = new Sha384();
                            break;
                        }
                        case 9: {
                            Hash = new Sha512();
                            break;
                        }
                        case 10: {
                            Hash = new Tiger();
                            break;
                        }
                        case 11: {
                            Hash = new Tiger2();
                            break;
                        }
                        case 12: {
                            Hash = new Tiger128();
                            break;
                        }
                        case 13: {
                            Hash = new Tiger160();
                            break;
                        }
                        case 14: {
                            Hash = new RipeMD128();
                            break;
                        }
                        case 15: {
                            Hash = new RipeMD160();
                            break;
                        }
                        case 16: {
                            Hash = new MD2();
                            break;
                        }
                        case 17: {
                            Hash = new MD4();
                            break;
                        }
                        case 18: {
                            Hash = new MD5();
                            break;
                        }
                        case 19: {
                            Hash = new Haval(16);
                            break;
                        }
                        case 20: {
                            Hash = new Haval(20);
                            break;
                        }
                        case 21: {
                            Hash = new Haval(24);
                            break;
                        }
                        case 22: {
                            Hash = new Haval(28);
                            break;
                        }
                        case 23: {
                            Hash = new Haval(32);
                            break;
                        }
                        case 24: {
                            Hash = new Has160();
                            break;
                        }
                        case 25: {
                            Hash = new CRC32();
                            break;
                        }
                        case 26: {
                            Hash = new CRC64();
                            break;
                        }
                        case 0: {
                            Hash = null;
                            break;
                        }
                        default: {
                            Hash = new Whirlpool2003();
                        }
                    }
                    if (Hash != null) {
                        Hash.reset();
                    }
                    if (Output == null || Output.isDirectory()) {
                        HTemp = new long[HeaderLength - 8];
                        for (i = 0; i < HTemp.length; ++i) {
                            HTemp[i] = Header[4 + i];
                        }
                        String OutputFileName = new String(Converter.long2byte(HTemp));
                        OutputFileName = OutputFileName.substring(0, OutputFileNameLength);
                        Output = Output != null && Output.isDirectory() ? new FileManager(Output.getFilePath() + Output.getSeparador() + OutputFileName) : new FileManager(InputCodecFilePath + Input.getSeparador() + OutputFileName);
                        this.FileParameters.setOutput(Output);
                    }
                    if (Output.Exists() && !Output.Delete()) {
                        ex3 = this;
                        synchronized (ex3) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo borrar el archivo " + Output.getAbsoluteFilePath(), 8);
                        }
                    }
                    try {
                        Output.Open(1);
                    }
                    catch (UtilsException ex5) {
                        AESFile aESFile8 = this;
                        synchronized (aESFile8) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo crear el archivo " + Output.getAbsoluteFilePath(), 9);
                        }
                    }
                    try {
                        Input.Reset();
                    }
                    catch (UtilsException ex6) {
                        AESFile aESFile9 = this;
                        synchronized (aESFile9) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se pudo abrir el archivo " + Input.getAbsoluteFilePath(), 5);
                        }
                    }
                    ex3 = this;
                    synchronized (ex3) {
                        InputBuffer = new byte[this.BufferSize];
                        break block148;
                    }
                }
                if (!Input.isDirectory()) {
                    AESFile aESFile10 = this;
                    synchronized (aESFile10) {
                        this.Progress = -1;
                        throw new UtilsException("ERROR: NO se puede identificar el tipo de archivo a codificar", 13);
                    }
                }
                break block147;
            }
            byte[] SubInputBuffer = new byte[16];
            NumBytesReads = InputBuffer.length;
            long NumBytesWrite = 0L;
            long NumBlocksRead = 0L;
            while (true) {
                int DTemp;
                block150: {
                    int j;
                    block151: {
                        block149: {
                            if ((long)InputBuffer.length != NumBytesReads) break block149;
                            try {
                                NumBytesReads = Input.Read(InputBuffer);
                            }
                            catch (UtilsException ex7) {
                                AESFile aESFile11 = this;
                                synchronized (aESFile11) {
                                    this.Progress = -1;
                                    throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                                }
                            }
                            if (NumBytesReads <= 0L) break block150;
                            if (NumBlocksRead <= HPosc && NumBlocksRead + NumBytesReads / 8L > HPosc) {
                                DTemp = (int)(8L * (HPosc - NumBlocksRead));
                                if (DTemp + 8 * HeaderLength < InputBuffer.length) {
                                    for (i = DTemp; i < InputBuffer.length - 8 * HeaderLength; ++i) {
                                        InputBuffer[i] = InputBuffer[i + 8 * HeaderLength];
                                    }
                                    NumBytesReads -= (long)(8 * HeaderLength);
                                    SubInputBuffer = new byte[8 * HeaderLength];
                                } else {
                                    i = 8 * HeaderLength + DTemp - InputBuffer.length;
                                    try {
                                        Input.Skip(i);
                                    }
                                    catch (UtilsException ex8) {
                                        AESFile aESFile12 = this;
                                        synchronized (aESFile12) {
                                            this.Progress = -1;
                                            throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                                        }
                                    }
                                    i = InputBuffer.length - DTemp;
                                    NumBytesReads -= (long)i;
                                    SubInputBuffer = new byte[i];
                                }
                                try {
                                    DTemp = (int)Input.Read(SubInputBuffer);
                                }
                                catch (UtilsException ex9) {
                                    AESFile aESFile13 = this;
                                    synchronized (aESFile13) {
                                        this.Progress = -1;
                                        throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                                    }
                                }
                                if (DTemp > 0) {
                                    ArrayUtils.arrayCopy(SubInputBuffer, 0, InputBuffer, InputBuffer.length - DTemp, DTemp);
                                    NumBytesReads += (long)DTemp;
                                }
                                NumBlocksRead += NumBytesReads / 8L;
                                SubInputBuffer = new byte[16];
                            }
                            i = 0;
                            break block151;
                        }
                        if (Hash != null && !Arrays.equals(OrgDigest, NewDigest = Hash.digest())) {
                            ex3 = this;
                            synchronized (ex3) {
                                this.Progress = -1;
                                throw new UtilsException("ERROR: HASH NO COINCIDEN", 1);
                            }
                        }
                        try {
                            Input.Close();
                        }
                        catch (UtilsException ex10) {
                            AESFile aESFile14 = this;
                            synchronized (aESFile14) {
                                this.Progress = -1;
                                throw new UtilsException("ERROR: NO se puede cerrar el archivo " + Input.getAbsoluteFilePath(), 11);
                            }
                        }
                        try {
                            Output.Close();
                            break;
                        }
                        catch (UtilsException ex11) {
                            AESFile aESFile15 = this;
                            synchronized (aESFile15) {
                                this.Progress = -1;
                                throw new UtilsException("ERROR: NO se puede cerrar el archivo " + Output.getAbsoluteFilePath(), 12);
                            }
                        }
                    }
                    while ((long)i < NumBytesReads) {
                        for (j = 0; j < 16; ++j) {
                            SubInputBuffer[j] = InputBuffer[i + j];
                        }
                        ex3 = this.AES;
                        synchronized (ex3) {
                            SubInputBuffer = this.AES.Decrypt(SubInputBuffer);
                        }
                        for (j = 0; j < 16; ++j) {
                            InputBuffer[i + j] = SubInputBuffer[j];
                        }
                        i += 16;
                    }
                    if (NumBytesWrite + NumBytesReads > OutputFileLength) {
                        NumBytesReads = (int)(OutputFileLength - NumBytesWrite);
                        if (Hash != null) {
                            if (NumBytesReads + (long)Hash.hashSize() < (long)InputBuffer.length) {
                                OrgDigest = (byte[])ArrayUtils.subArray(InputBuffer, (int)NumBytesReads, Hash.hashSize());
                            } else {
                                OrgDigest = new byte[(int)(16.0 * Math.ceil((double)(NumBytesReads + (long)Hash.hashSize() - (long)InputBuffer.length) / 16.0))];
                                try {
                                    DTemp = (int)Input.Read(OrgDigest);
                                }
                                catch (UtilsException ex12) {
                                    AESFile aESFile16 = this;
                                    synchronized (aESFile16) {
                                        this.Progress = -1;
                                        throw new UtilsException("ERROR: NO se pudo leer el archivo " + Input.getAbsoluteFilePath(), 6);
                                    }
                                }
                                for (i = 0; i < DTemp; i += 16) {
                                    for (j = 0; j < 16; ++j) {
                                        SubInputBuffer[j] = OrgDigest[i + j];
                                    }
                                    ex3 = this.AES;
                                    synchronized (ex3) {
                                        SubInputBuffer = this.AES.Decrypt(SubInputBuffer);
                                    }
                                    for (j = 0; j < 16; ++j) {
                                        OrgDigest[i + j] = SubInputBuffer[j];
                                    }
                                }
                                OrgDigest = (byte[])ArrayUtils.resizeArray(OrgDigest, (int)(NumBytesReads + (long)Hash.hashSize() - (long)InputBuffer.length));
                                InputBuffer = (byte[])ArrayUtils.resizeArray(InputBuffer, InputBuffer.length + OrgDigest.length);
                                ArrayUtils.arrayCopy(OrgDigest, 0, InputBuffer, InputBuffer.length - OrgDigest.length, OrgDigest.length);
                                OrgDigest = (byte[])ArrayUtils.subArray(InputBuffer, (int)NumBytesReads, Hash.hashSize());
                            }
                        }
                    }
                    if (Hash != null) {
                        Hash.update(InputBuffer, 0, (int)NumBytesReads);
                    }
                    try {
                        Output.Write(InputBuffer, 0, (int)NumBytesReads);
                    }
                    catch (UtilsException ex13) {
                        AESFile aESFile17 = this;
                        synchronized (aESFile17) {
                            this.Progress = -1;
                            throw new UtilsException("ERROR: NO se puede escribir en el archivo " + Output.getAbsoluteFilePath(), 10);
                        }
                    }
                    NumBytesWrite += NumBytesReads;
                    NumBlocksRead += NumBytesReads / 8L;
                }
                if ((DTemp = OutputFileLength > 0L ? (int)(NumBytesWrite * 100L / OutputFileLength) : 0) == 100) {
                    DTemp = 99;
                }
                ex3 = this;
                synchronized (ex3) {
                    this.Progress = DTemp;
                }
            }
        }
        aESFile = this;
        synchronized (aESFile) {
            this.Progress = 100;
            return;
        }
    }

    @Override
    public synchronized void Codec(FileManager Input, FileManager Output, int Opciones) {
        if (this.Ejecutando == null || this.Ejecutando.getState() == Thread.State.TERMINATED) {
            this.Progress = 0;
            this.FileParameters = new FileOperationParameters(Input, Output, Opciones);
            this.Coding = true;
            this.Ejecutando = new Thread((Runnable)this, "Coding");
            this.Ejecutando.start();
        }
    }

    @Override
    public synchronized void Decodec(FileManager Input, FileManager Output) {
        if (this.Ejecutando == null || this.Ejecutando.getState() == Thread.State.TERMINATED) {
            this.Progress = 0;
            this.FileParameters = new FileOperationParameters(Input, Output, 0);
            this.Coding = false;
            this.Ejecutando = new Thread((Runnable)this, "Decoding");
            this.Ejecutando.start();
        }
    }

    @Override
    public synchronized int Progress() {
        return this.Progress;
    }

    @Override
    public synchronized boolean isDone() {
        return this.Progress == 100 || this.Progress == -1;
    }

    public synchronized int getErrorCode() {
        return this.ErrorCode;
    }

    public synchronized boolean hasError() {
        return (this.Ejecutando != null || this.Ejecutando.getState() == Thread.State.TERMINATED) && this.ErrorCode != 0;
    }

    @Override
    public synchronized FileManager getOutputFile() {
        FileManager Salida = null;
        if (this.FileParameters != null && ((Salida = this.FileParameters.getOutput()) == null || Salida.isDirectory())) {
            Salida = null;
        }
        return Salida;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: {
            AESFile aESFile = this;
            synchronized (aESFile) {
                this.ErrorCode = 0;
            }
            if (this.Coding) {
                try {
                    this.PrivCodec();
                }
                catch (UtilsException ex) {
                    AESFile aESFile2 = this;
                    synchronized (aESFile2) {
                        this.ErrorCode = ex.getErrorCode();
                    }
                    if (this.Log != null) {
                        this.Log.LogMessage(2, 5, AESFile.class.getName(), ex.getLocalizedMessage());
                        break block17;
                    }
                    Logger.getLogger(AESFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                try {
                    this.PrivDecodec();
                }
                catch (UtilsException ex) {
                    AESFile aESFile3 = this;
                    synchronized (aESFile3) {
                        this.ErrorCode = ex.getErrorCode();
                    }
                    if (this.Log != null) {
                        this.Log.LogMessage(2, 5, AESFile.class.getName(), ex.getLocalizedMessage());
                    }
                    Logger.getLogger(AESFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private class FileOperationParameters {
        private FileManager Input;
        private FileManager Output;
        private int Opciones;

        public FileOperationParameters(FileManager Input, FileManager Output, int Opciones) {
            this.Input = Input;
            this.Output = Output;
            this.Opciones = Opciones;
        }

        public synchronized FileManager getInput() {
            return this.Input;
        }

        public synchronized void setInput(FileManager Input) {
            this.Input = Input;
        }

        public synchronized FileManager getOutput() {
            return this.Output;
        }

        public synchronized void setOutput(FileManager Output) {
            this.Output = Output;
        }

        public synchronized int getOpciones() {
            return this.Opciones;
        }

        public synchronized void setOpciones(int Opciones) {
            this.Opciones = Opciones;
        }
    }
}

