/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.numericalalgorith;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.numericalalgorith.Matrix;
import com.valhalanetworks.utils.numericalalgorith.NAFunction;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;

public strictfp class NewtonRaphson {
    private NAFunction[] Fx;
    private double TargetError;
    private boolean InitialPoint;
    private double[] x;
    private double[] BestX;
    private long MaxNumIterations;
    private double MinError;
    private boolean ErrorMagnifier;
    private double Magnifier;
    public static final int FuntionDimensionNotMatch = 1;

    public NewtonRaphson(NAFunction[] Fx) {
        this.Fx = Fx;
        this.TargetError = 1.0E-6;
        this.InitialPoint = false;
        this.x = null;
        this.MinError = 1.0E20;
        this.MaxNumIterations = 100000000L;
        this.ErrorMagnifier = false;
        this.Magnifier = 3.0;
    }

    public long getMaxNumIterations() {
        return this.MaxNumIterations;
    }

    public void setMaxNumIterations(long MaxNumIterations) {
        this.MaxNumIterations = MaxNumIterations;
    }

    public double getMinError() {
        return this.MinError;
    }

    public double getError() {
        return this.TargetError;
    }

    public void setError(double TargetError) {
        this.TargetError = TargetError;
    }

    public boolean isErrorMagnifier() {
        return this.ErrorMagnifier;
    }

    public void setErrorMagnifier(boolean ErrorMagnifier) {
        this.ErrorMagnifier = ErrorMagnifier;
    }

    public int getMagnifier() {
        return (int)this.Magnifier;
    }

    public void setMagnifier(int Magnifier) {
        this.Magnifier = Magnifier > 0 ? (double)Magnifier : 1.0;
    }

    private double Error(double[] Punto) throws UtilsException {
        int NumEcuaciones = this.Fx.length;
        double NewError = 0.0;
        for (int i = 0; i < NumEcuaciones; ++i) {
            double ParcialError = Math.abs(this.Fx[i].Eval(Punto));
            if (this.ErrorMagnifier) {
                ParcialError = ParcialError >= 1.0 ? Math.pow(ParcialError, this.Magnifier) : Math.pow(ParcialError, 1.0 / this.Magnifier);
            }
            NewError += ParcialError;
        }
        return NewError;
    }

    public void setInicialEstimation(double[] InicialEstimation) throws UtilsException {
        int Dimension = this.Fx[0].Dimension();
        if (Dimension == InicialEstimation.length) {
            this.x = new double[Dimension];
            for (int i = 0; i < Dimension; ++i) {
                this.x[i] = InicialEstimation[i];
            }
        } else {
            throw new UtilsException("ERROR: Initial Estimation don't match equation's dimension", 1);
        }
        this.InitialPoint = true;
    }

    public double[] Resolve() throws UtilsException {
        int i;
        int Dimension = this.Fx[0].Dimension();
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        if (!this.InitialPoint) {
            this.x = new double[Dimension];
            for (i = 0; i < Dimension; ++i) {
                this.x[i] = Aleatorio.nextDouble() * (double)Aleatorio.nextByte();
            }
        }
        double Error2 = Math.abs(this.Error(this.x));
        this.BestX = new double[Dimension];
        for (i = 0; i < Dimension; ++i) {
            this.BestX[i] = this.x[i];
        }
        this.MinError = Error2;
        long Iteraciones = 0L;
        Matrix Jacobiana = new Matrix(Dimension, Dimension);
        Matrix Funcion = new Matrix(Dimension, 1);
        int NumFuncions = this.Fx.length;
        while (Error2 > this.TargetError) {
            for (i = 0; i < NumFuncions; ++i) {
                for (int j = 0; j < Dimension; ++j) {
                    Jacobiana.setValue(i, j, this.Fx[i].DPEval(this.x, j));
                }
                Funcion.setValue(i, 0, this.Fx[i].Eval(this.x));
            }
            Jacobiana = Jacobiana.Inv();
            Jacobiana = Jacobiana.PScalar(-1.0);
            Matrix Delta = Jacobiana.Multi(Funcion);
            for (i = 0; i < Dimension; ++i) {
                int n = i;
                this.x[n] = this.x[n] + Delta.getValue(i, 0);
            }
            Error2 = Math.abs(this.Error(this.x));
            if (Error2 < this.MinError) {
                this.MinError = Error2;
                for (i = 0; i < Dimension; ++i) {
                    this.BestX[i] = this.x[i];
                }
            }
            if (Iteraciones > this.MaxNumIterations) {
                Error2 = this.TargetError;
            }
            ++Iteraciones;
        }
        return this.BestX;
    }
}

