/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.crypto.digest;

public class StringUtils {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final String BASE64_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./";
    private static final char[] BASE64_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();

    private StringUtils() {
    }

    public static String toString(byte[] ba) {
        return StringUtils.toString(ba, 0, ba.length);
    }

    public static final String toString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[offset + i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String toReversedString(byte[] ba) {
        return StringUtils.toReversedString(ba, 0, ba.length);
    }

    public static final String toReversedString(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int i = offset + length - 1;
        int j = 0;
        while (i >= offset) {
            byte k = ba[offset + i--];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] toBytesFromString(String s) {
        int limit = s.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        int j = 0;
        if (limit % 2 == 1) {
            result[j++] = (byte)StringUtils.fromDigit(s.charAt(i++));
        }
        while (i < limit) {
            result[j] = (byte)(StringUtils.fromDigit(s.charAt(i++)) << 4);
            int n = j++;
            result[n] = (byte)(result[n] | (byte)StringUtils.fromDigit(s.charAt(i++)));
        }
        return result;
    }

    public static byte[] toReversedBytesFromString(String s) {
        int limit = s.length();
        byte[] result = new byte[(limit + 1) / 2];
        int i = 0;
        if (limit % 2 == 1) {
            result[i++] = (byte)StringUtils.fromDigit(s.charAt(--limit));
        }
        while (limit > 0) {
            result[i] = (byte)StringUtils.fromDigit(s.charAt(--limit));
            int n = i++;
            result[n] = (byte)(result[n] | (byte)(StringUtils.fromDigit(s.charAt(--limit)) << 4));
        }
        return result;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hexadecimal digit: " + c);
    }

    public static String toString(int n) {
        char[] buf = new char[8];
        for (int i = 7; i >= 0; --i) {
            buf[i] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
        }
        return new String(buf);
    }

    public static String toString(int[] ia) {
        int length = ia.length;
        char[] buf = new char[length * 8];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int k = ia[i];
            buf[j++] = HEX_DIGITS[k >>> 28 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 24 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 20 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 16 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 12 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 8 & 0xF];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static String toString(long n) {
        char[] b = new char[16];
        for (int i = 15; i >= 0; --i) {
            b[i] = HEX_DIGITS[(int)(n & 0xFL)];
            n >>>= 4;
        }
        return new String(b);
    }

    public static String toUnicodeString(byte[] ba) {
        return StringUtils.toUnicodeString(ba, 0, ba.length);
    }

    public static final String toUnicodeString(byte[] ba, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < length) {
            sb.append("\\u");
            byte k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            k = ba[offset + i++];
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 8 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static String toUnicodeString(int[] ia) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        sb.append('\n').append("\"");
        while (i < ia.length) {
            int k = ia[i++];
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 28 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 24 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 20 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 16 & 0xF]);
            sb.append("\\u");
            sb.append(HEX_DIGITS[k >>> 12 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 8 & 0xF]);
            sb.append(HEX_DIGITS[k >>> 4 & 0xF]);
            sb.append(HEX_DIGITS[k & 0xF]);
            if (++j % 4 != 0) continue;
            sb.append("\"+").append('\n').append("\"");
        }
        sb.append("\"").append('\n');
        return sb.toString();
    }

    public static byte[] toBytesFromUnicode(String s) {
        int limit = s.length() * 2;
        byte[] result = new byte[limit];
        for (int i = 0; i < limit; ++i) {
            int c = s.charAt(i >>> 1);
            result[i] = (byte)((i & 1) == 0 ? c >>> 8 : c);
        }
        return result;
    }

    public static String dumpString(byte[] data, int offset, int length, String m) {
        if (data == null) {
            return m + "null\n";
        }
        StringBuffer sb = new StringBuffer(length * 3);
        if (length > 32) {
            sb.append(m).append("Hexadecimal dump of ").append(length).append(" bytes...\n");
        }
        int end = offset + length;
        int l = Integer.toString(length).length();
        if (l < 4) {
            l = 4;
        }
        while (offset < end) {
            int i;
            if (length > 32) {
                String s = "         " + offset;
                sb.append(m).append(s.substring(s.length() - l)).append(": ");
            }
            for (i = 0; i < 32 && offset + i + 7 < end; i += 8) {
                sb.append(StringUtils.toString(data, offset + i, 8)).append(' ');
            }
            if (i < 32) {
                while (i < 32 && offset + i < end) {
                    sb.append(StringUtils.byteToString(data[offset + i]));
                    ++i;
                }
            }
            sb.append('\n');
            offset += 32;
        }
        return sb.toString();
    }

    public static String dumpString(byte[] data) {
        return data == null ? "null\n" : StringUtils.dumpString(data, 0, data.length, "");
    }

    public static String dumpString(byte[] data, String m) {
        return data == null ? "null\n" : StringUtils.dumpString(data, 0, data.length, m);
    }

    public static String dumpString(byte[] data, int offset, int length) {
        return StringUtils.dumpString(data, offset, length, "");
    }

    public static String byteToString(int n) {
        char[] buf = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }
}

