/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.numericalalgorith;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;

public strictfp abstract class NAFunction {
    public static final int EmptyInput = 1;
    public static final int Infinite = 2;
    public static final int NoDet = 3;
    public static final int ErrorInputFormat = 4;
    public static final int ErrorVarPos = 5;
    private double h;

    public NAFunction() {
        this.h = 0.01;
    }

    public NAFunction(double Delta) {
        this.h = Math.abs(Delta);
    }

    public void setDelta(double Delta) {
        this.h = Math.abs(Delta);
    }

    public double getDelta() {
        return this.h;
    }

    public void ResetDelta() {
        this.h = 0.01;
    }

    public abstract double Eval(double[] var1) throws UtilsException;

    public abstract int Dimension();

    public double DEval(double[] x) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            MasDelta[i] = x[i] + this.h;
            MenosDelta[i] = x[i] - this.h;
            Mas2Delta[i] = x[i] + 2.0 * this.h;
            Menos2Delta[i] = x[i] - 2.0 * this.h;
        }
        double Salida = (this.Eval(Menos2Delta) - this.Eval(Mas2Delta) - 8.0 * this.Eval(MenosDelta) + 8.0 * this.Eval(MasDelta)) / (12.0 * this.h);
        return Salida;
    }

    public double DPEval(double[] x, int VarPos) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        if (VarPos < 0 || VarPos >= x.length) {
            throw new UtilsException("Variable a derivar fuera del rango", 5);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            if (i == VarPos) {
                MasDelta[i] = x[i] + this.h;
                MenosDelta[i] = x[i] - this.h;
                Mas2Delta[i] = x[i] + 2.0 * this.h;
                Menos2Delta[i] = x[i] - 2.0 * this.h;
                continue;
            }
            MasDelta[i] = x[i];
            MenosDelta[i] = x[i];
            Mas2Delta[i] = x[i];
            Menos2Delta[i] = x[i];
        }
        double Salida = (this.Eval(Menos2Delta) - this.Eval(Mas2Delta) - 8.0 * this.Eval(MenosDelta) + 8.0 * this.Eval(MasDelta)) / (12.0 * this.h);
        return Salida;
    }

    public double D2Eval(double[] x) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            MasDelta[i] = x[i] + this.h;
            MenosDelta[i] = x[i] - this.h;
            Mas2Delta[i] = x[i] + 2.0 * this.h;
            Menos2Delta[i] = x[i] - 2.0 * this.h;
        }
        double Salida = (-this.Eval(Mas2Delta) + 16.0 * this.Eval(MasDelta) - 30.0 * this.Eval(x) + 16.0 * this.Eval(MenosDelta) - this.Eval(Menos2Delta)) / (12.0 * this.h * this.h);
        return Salida;
    }

    public double DP2Eval(double[] x, int VarPos) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        if (VarPos < 0 || VarPos >= x.length) {
            throw new UtilsException("Variable a derivar fuera del rango", 5);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            if (i == VarPos) {
                MasDelta[i] = x[i] + this.h;
                MenosDelta[i] = x[i] - this.h;
                Mas2Delta[i] = x[i] + 2.0 * this.h;
                Menos2Delta[i] = x[i] - 2.0 * this.h;
                continue;
            }
            MasDelta[i] = x[i];
            MenosDelta[i] = x[i];
            Mas2Delta[i] = x[i];
            Menos2Delta[i] = x[i];
        }
        double Salida = (-this.Eval(Mas2Delta) + 16.0 * this.Eval(MasDelta) - 30.0 * this.Eval(x) + 16.0 * this.Eval(MenosDelta) - this.Eval(Menos2Delta)) / (12.0 * this.h * this.h);
        return Salida;
    }

    public double D3Eval(double[] x) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        double[] Mas3Delta = new double[NumEle];
        double[] Menos3Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            MasDelta[i] = x[i] + this.h;
            MenosDelta[i] = x[i] - this.h;
            Mas2Delta[i] = x[i] + 2.0 * this.h;
            Menos2Delta[i] = x[i] - 2.0 * this.h;
            Mas3Delta[i] = x[i] + 3.0 * this.h;
            Menos3Delta[i] = x[i] - 3.0 * this.h;
        }
        double Salida = (this.Eval(Menos3Delta) - 8.0 * this.Eval(Menos2Delta) + 13.0 * this.Eval(MenosDelta) - 13.0 * this.Eval(MasDelta) + 8.0 * this.Eval(Mas2Delta) - this.Eval(Mas3Delta)) / (8.0 * this.h * this.h * this.h);
        return Salida;
    }

    public double DP3Eval(double[] x, int VarPos) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        if (VarPos < 0 || VarPos >= x.length) {
            throw new UtilsException("Variable a derivar fuera del rango", 5);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        double[] Mas3Delta = new double[NumEle];
        double[] Menos3Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            if (i == VarPos) {
                MasDelta[i] = x[i] + this.h;
                MenosDelta[i] = x[i] - this.h;
                Mas2Delta[i] = x[i] + 2.0 * this.h;
                Menos2Delta[i] = x[i] - 2.0 * this.h;
                Mas3Delta[i] = x[i] + 3.0 * this.h;
                Menos3Delta[i] = x[i] - 3.0 * this.h;
                continue;
            }
            MasDelta[i] = x[i];
            MenosDelta[i] = x[i];
            Mas2Delta[i] = x[i];
            Menos2Delta[i] = x[i];
            Mas3Delta[i] = x[i];
            Menos3Delta[i] = x[i];
        }
        double Salida = (this.Eval(Menos3Delta) - 8.0 * this.Eval(Menos2Delta) + 13.0 * this.Eval(MenosDelta) - 13.0 * this.Eval(MasDelta) + 8.0 * this.Eval(Mas2Delta) - this.Eval(Mas3Delta)) / (8.0 * this.h * this.h * this.h);
        return Salida;
    }

    public double D4Eval(double[] x) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        double[] Mas3Delta = new double[NumEle];
        double[] Menos3Delta = new double[NumEle];
        double[] Mas4Delta = new double[NumEle];
        double[] Menos4Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            MasDelta[i] = x[i] + this.h;
            MenosDelta[i] = x[i] - this.h;
            Mas2Delta[i] = x[i] + 2.0 * this.h;
            Menos2Delta[i] = x[i] - 2.0 * this.h;
            Mas3Delta[i] = x[i] + 3.0 * this.h;
            Menos3Delta[i] = x[i] - 3.0 * this.h;
            Mas4Delta[i] = x[i] + 4.0 * this.h;
            Menos4Delta[i] = x[i] - 4.0 * this.h;
        }
        double Salida = (-1.0 * this.Eval(Menos3Delta) + 12.0 * this.Eval(Menos2Delta) - 39.0 * this.Eval(MenosDelta) + 56.0 * this.Eval(x) - 39.0 * this.Eval(MasDelta) + 12.0 * this.Eval(Mas2Delta) - this.Eval(Mas3Delta)) / (6.0 * this.h * this.h * this.h * this.h);
        return Salida;
    }

    public double DP4Eval(double[] x, int VarPos) throws UtilsException {
        if (x == null || x.length < 1) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        if (VarPos < 0 || VarPos >= x.length) {
            throw new UtilsException("Variable a derivar fuera del rango", 5);
        }
        int NumEle = x.length;
        double[] MasDelta = new double[NumEle];
        double[] MenosDelta = new double[NumEle];
        double[] Mas2Delta = new double[NumEle];
        double[] Menos2Delta = new double[NumEle];
        double[] Mas3Delta = new double[NumEle];
        double[] Menos3Delta = new double[NumEle];
        double[] Mas4Delta = new double[NumEle];
        double[] Menos4Delta = new double[NumEle];
        for (int i = 0; i < NumEle; ++i) {
            if (i == VarPos) {
                MasDelta[i] = x[i] + this.h;
                MenosDelta[i] = x[i] - this.h;
                Mas2Delta[i] = x[i] + 2.0 * this.h;
                Menos2Delta[i] = x[i] - 2.0 * this.h;
                Mas3Delta[i] = x[i] + 3.0 * this.h;
                Menos3Delta[i] = x[i] - 3.0 * this.h;
                Mas4Delta[i] = x[i] + 4.0 * this.h;
                Menos4Delta[i] = x[i] - 4.0 * this.h;
                continue;
            }
            MasDelta[i] = x[i];
            MenosDelta[i] = x[i];
            Mas2Delta[i] = x[i];
            Menos2Delta[i] = x[i];
            Mas3Delta[i] = x[i];
            Menos3Delta[i] = x[i];
            Mas4Delta[i] = x[i];
            Menos4Delta[i] = x[i];
        }
        double Salida = (-1.0 * this.Eval(Menos3Delta) + 12.0 * this.Eval(Menos2Delta) - 39.0 * this.Eval(MenosDelta) + 56.0 * this.Eval(x) - 39.0 * this.Eval(MasDelta) + 12.0 * this.Eval(Mas2Delta) - this.Eval(Mas3Delta)) / (6.0 * this.h * this.h * this.h * this.h);
        return Salida;
    }

    public double Integration(double[][] V) throws UtilsException {
        int i;
        if (V == null) {
            throw new UtilsException("Entrada Vacia", 1);
        }
        if (V[0].length != 2) {
            throw new UtilsException("Dimensionalidad de la entrada no es una dupla", 4);
        }
        if (V.length != this.Dimension()) {
            throw new UtilsException("Dimensionalidad de la entrada no es igual a la dimensionalidad de la funcion", 4);
        }
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        int Dimension = V.length;
        double Salida = 1.0;
        for (i = 0; i < Dimension; ++i) {
            Salida *= V[i][1] - V[i][0];
        }
        double[] Punto = new double[Dimension];
        int N = (int)(1.0 / (this.h * this.h));
        double Sumatoria = 0.0;
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < Dimension; ++j) {
                Punto[j] = (V[j][1] - V[j][0]) * Aleatorio.nextDouble() + V[j][0];
            }
            Sumatoria += this.Eval(Punto);
        }
        return Salida *= Sumatoria / (double)N;
    }
}

