/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.log;

import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.environment.EnvironmentUtils;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.sort.Sortable;
import com.valhalanetworks.utils.sort.Sorter;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileLogger
implements LoggerManager,
Runnable {
    private static final int QUEUESIZE = 1024;
    private static final long QUEUEWRITETIMEOUT = 100L;
    private static final long QUEUEREADTIMEOUT = 10L;
    private static final int THREADSLEEP = 500;
    public static final int TYPE_ALL = -1;
    public static final int LEVEL_ALL = -1;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private MersenneTwisterPlus Random = new MersenneTwisterPlus();
    private DateFormat dateFormat;
    @GuardedBy(value="rwl")
    private ArrayBlockingQueue<MessageLog> queue = null;
    private Thread Ejecutor = null;
    @GuardedBy(value="rwl")
    private boolean Ejecutar;
    @GuardedBy(value="this")
    private boolean Finalizado;
    private String ControlKey = null;
    private final String OS = EnvironmentUtils.getOS();
    private final String FileSeparador = this.OS != null && this.OS.toLowerCase(new Locale("en")).contains("windows") ? "\\" : "/";
    @GuardedBy(value="rwl")
    private static FileLogger instance = null;
    @GuardedBy(value="rwl")
    private String FilePath = "." + this.FileSeparador;
    @GuardedBy(value="rwl")
    private String FileBaseName = "Valhala_FileLogger";
    @GuardedBy(value="rwl")
    private boolean ChangedFileBaseName = false;
    @GuardedBy(value="rwl")
    private int SaveEventType = -1;
    @GuardedBy(value="rwl")
    private int SaveRegLevel = -1;
    @GuardedBy(value="rwl")
    private long LastCreateFileTime = 0L;
    @GuardedBy(value="rwl")
    private long RotateFileTimeThreshold = 3600000L;
    @GuardedBy(value="rwl")
    private long RotateFileSizeThreshold = 0xA00000L;
    @GuardedBy(value="rwl")
    private int NumFileToKeep = 10;

    private FileLogger() {
        this.queue = new ArrayBlockingQueue(1024);
        this.dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        this.StartThread();
    }

    public static FileLogger getInstance() {
        rwl.writeLock().lock();
        try {
            if (instance == null) {
                instance = new FileLogger();
            }
        }
        finally {
            rwl.writeLock().unlock();
        }
        return instance;
    }

    private void StartThread() {
        this.Ejecutor = new Thread(this);
        this.Ejecutor.setName("Valhala_File_Logger[" + Integer.toHexString(this.Random.nextInt31()) + "]");
        this.Ejecutor.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Logger.getLogger(t.getName()).log(Level.SEVERE, "Uncaught Exception\n" + e.toString());
            }
        });
        this.Ejecutar = true;
        this.Finalizado = false;
        this.Ejecutor.start();
    }

    private String KeyGenerator() {
        String Llave = null;
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        byte[] BinaryKey = new byte[128];
        Random2.nextBytes(BinaryKey);
        try {
            Llave = Base64.encodeBytes(BinaryKey, 4);
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage());
        }
        return Llave;
    }

    public String getControlKey() {
        String Llave = this.KeyGenerator();
        if (this.ControlKey == null) {
            this.ControlKey = new String(Llave);
        }
        return Llave;
    }

    public void setFullFileDescriptor(String FilePath, String FileBaseName) {
        if (!FilePath.substring(FilePath.length() - 1, FilePath.length()).equalsIgnoreCase(this.FileSeparador)) {
            FilePath = FilePath + this.FileSeparador;
        }
        rwl.writeLock().lock();
        try {
            this.FilePath = FilePath;
            this.FileBaseName = FileBaseName;
            this.ChangedFileBaseName = true;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public String getFilePath() {
        String Local;
        rwl.readLock().lock();
        try {
            Local = this.FilePath;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local;
    }

    public void setFilePath(String FilePath) {
        if (!FilePath.substring(FilePath.length() - 1, FilePath.length()).equalsIgnoreCase(this.FileSeparador)) {
            FilePath = FilePath + this.FileSeparador;
        }
        rwl.writeLock().lock();
        try {
            this.FilePath = FilePath;
            this.ChangedFileBaseName = true;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public String getFileBaseName() {
        String Local;
        rwl.readLock().lock();
        try {
            Local = this.FileBaseName;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local;
    }

    public void setFileBaseName(String FileBaseName) {
        rwl.writeLock().lock();
        try {
            this.FileBaseName = FileBaseName;
            this.ChangedFileBaseName = true;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public int getSaveEventTypes() {
        int Local;
        rwl.readLock().lock();
        try {
            Local = this.SaveEventType;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local;
    }

    public void setSaveEventTypes(int SaveEventType) {
        rwl.writeLock().lock();
        try {
            this.SaveEventType = SaveEventType;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public int getSaveRegLevel() {
        int Local;
        rwl.readLock().lock();
        try {
            Local = this.SaveRegLevel;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local;
    }

    public void setSaveRegLevel(int SaveRegLevel) {
        rwl.writeLock().lock();
        try {
            this.SaveRegLevel = SaveRegLevel;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public long getRotateFileTimeThreshold() {
        rwl.readLock().lock();
        try {
            long Local = this.RotateFileTimeThreshold;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local /= 60000L;
    }

    public void setRotateFileTimeThreshold(long RotateFileTimeThreshold) {
        RotateFileTimeThreshold *= 60000L;
        rwl.writeLock().lock();
        try {
            this.RotateFileTimeThreshold = RotateFileTimeThreshold;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public long getRotateFileSizeThreshold() {
        rwl.readLock().lock();
        try {
            long Local = this.RotateFileSizeThreshold;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local /= 0x100000L;
    }

    public void setRotateFileSizeThreshold(long RotateFileSizeThreshold) {
        RotateFileSizeThreshold *= 0x100000L;
        rwl.writeLock().lock();
        try {
            this.RotateFileSizeThreshold = RotateFileSizeThreshold;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    public int getNumFileToKeep() {
        int Local;
        rwl.readLock().lock();
        try {
            Local = this.NumFileToKeep;
        }
        finally {
            rwl.readLock().unlock();
        }
        return Local;
    }

    public void setNumFileToKeep(int NumFileToKeep) {
        rwl.writeLock().lock();
        try {
            this.NumFileToKeep = NumFileToKeep;
        }
        finally {
            rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void LogMessage(int Type2, int level, String Unit, String Messaje) {
        boolean LEjecutar;
        int Llevel;
        int LType;
        boolean Agregado = false;
        MessageLog msg = null;
        rwl.readLock().lock();
        try {
            LType = this.SaveEventType & Type2;
            Llevel = this.SaveRegLevel & level;
            LEjecutar = this.Ejecutar;
        }
        finally {
            rwl.readLock().unlock();
        }
        if (LEjecutar && LType != 0 && Llevel != 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SS");
            Calendar rightNow = Calendar.getInstance();
            String dateNow = formatter.format(rightNow.getTime());
            msg = new MessageLog(Type2, level, Unit, dateNow, Messaje);
            do {
                rwl.writeLock().lock();
                try {
                    Agregado = this.queue.offer(msg, 100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(instance.getClass().getName()).log(Level.SEVERE, ex.getMessage());
                }
                finally {
                    rwl.writeLock().unlock();
                }
                if (Agregado) continue;
                try {
                    Thread.sleep(this.Random.nextInt(1500));
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            } while (!Agregado);
        }
    }

    public final void Clear(String CtrlKey) {
        if (this.Ejecutor != null) {
            Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Message Queue Cleaned");
        } else {
            Logger.getLogger(FileLogger.class.getName()).log(Level.INFO, "Message Queue Cleaned");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            rwl.writeLock().lock();
            try {
                this.queue.clear();
            }
            finally {
                rwl.writeLock().unlock();
            }
        } else {
            Logger.getLogger(FileLogger.class.getName()).log(Level.WARNING, "Shutdown Failed due Control Key MISMATCH");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Shutdown(String CtrlKey) {
        if (this.Ejecutor != null) {
            Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Shutdown Started");
        } else {
            Logger.getLogger(FileLogger.class.getName()).log(Level.INFO, "Shutdown Started");
        }
        if (this.ControlKey == null || this.ControlKey.equals(CtrlKey)) {
            boolean lFin;
            rwl.writeLock().lock();
            try {
                this.Ejecutar = false;
            }
            finally {
                rwl.writeLock().unlock();
            }
            FileLogger fileLogger = this;
            synchronized (fileLogger) {
                lFin = this.Finalizado;
            }
            while (!lFin) {
                try {
                    Thread.sleep(this.Random.nextInt(500));
                }
                catch (InterruptedException ex) {
                    if (this.Ejecutor != null) {
                        Logger.getLogger(this.Ejecutor.getName()).log(Level.SEVERE, ex.getMessage());
                    }
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
                fileLogger = this;
                synchronized (fileLogger) {
                    lFin = this.Finalizado;
                }
            }
            if (this.Ejecutor != null) {
                Logger.getLogger(this.Ejecutor.getName()).log(Level.INFO, "Shutdown Completed");
            } else {
                Logger.getLogger(FileLogger.class.getName()).log(Level.INFO, "Shutdown Completed");
            }
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Shutdown Failed due Control Key MISMATCH");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        boolean lFin;
        rwl.writeLock().lock();
        try {
            this.Ejecutar = false;
        }
        finally {
            rwl.writeLock().unlock();
        }
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            lFin = this.Finalizado;
        }
        while (!lFin) {
            try {
                Thread.sleep(this.Random.nextInt(500));
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
            }
            fileLogger = this;
            synchronized (fileLogger) {
                lFin = this.Finalizado;
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void VerifyFilesToKeep() {
        int LNumFileToKeep;
        FileManager Directorio = null;
        Sortable[] Archivos = null;
        String ArchPath = null;
        FilenameFilter LogFilter = (Dir, Name) -> Name.contains(this.FileBaseName.subSequence(0, this.FileBaseName.length()));
        rwl.readLock().lock();
        try {
            ArchPath = this.FilePath;
            LNumFileToKeep = this.NumFileToKeep;
        }
        finally {
            rwl.readLock().unlock();
        }
        if (LNumFileToKeep <= 0) return;
        if (ArchPath.substring(ArchPath.length() - 1, ArchPath.length()).equalsIgnoreCase(this.FileSeparador)) {
            rwl.writeLock().lock();
            try {
                ArchPath = ArchPath.substring(0, ArchPath.length() - 1);
            }
            finally {
                rwl.writeLock().unlock();
            }
        }
        if ((Directorio = new FileManager(ArchPath)).isDirectory()) {
            try {
                Archivos = Directorio.ListDirectory(LogFilter);
                Sorter.RelativeSort(Archivos, false);
                if (Archivos.length <= LNumFileToKeep) return;
                for (int i = LNumFileToKeep; i < Archivos.length; ++i) {
                    if (!((FileManager)Archivos[i]).Exists()) continue;
                    ((FileManager)Archivos[i]).Delete();
                }
                return;
            }
            catch (UtilsException ex) {
                Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        } else {
            Logger.getLogger(instance.getClass().getName()).log(Level.WARNING, ArchPath + " NOT is a directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCanonicalFileBase() {
        String ArchName = null;
        rwl.readLock().lock();
        try {
            ArchName = this.FilePath;
        }
        finally {
            rwl.readLock().unlock();
        }
        if (!ArchName.substring(ArchName.length() - 1, ArchName.length()).equalsIgnoreCase(this.FileSeparador)) {
            rwl.writeLock().lock();
            try {
                ArchName = this.FilePath = this.FilePath + this.FileSeparador;
            }
            finally {
                rwl.writeLock().unlock();
            }
        }
        rwl.readLock().lock();
        try {
            ArchName = ArchName + this.FileBaseName;
        }
        finally {
            rwl.readLock().unlock();
        }
        return ArchName;
    }

    private String FormatMessage(MessageLog msg) {
        int Type2 = msg.getType();
        int Level2 = msg.getLevel();
        String dateNow = msg.getTimeStamp();
        StringBuffer Salida = new StringBuffer("++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        Salida = Salida.append("When: " + dateNow + "\n");
        Salida = Salida.append("Where: " + msg.getUnit() + "\n");
        Salida = Salida.append("Type: ");
        switch (Type2) {
            case 1: {
                Salida = Salida.append("Event\n");
                break;
            }
            case 2: {
                Salida = Salida.append("Error\n");
                break;
            }
            default: {
                Salida = Salida.append("Unknow\n");
            }
        }
        Salida = Salida.append("Level: ");
        switch (Level2) {
            case 4: {
                Salida = Salida.append("Trace\n");
                break;
            }
            case 8: {
                Salida = Salida.append("Debug\n");
                break;
            }
            case 16: {
                Salida = Salida.append("Info\n");
                break;
            }
            case 32: {
                Salida = Salida.append("Warning\n");
                break;
            }
            case 64: {
                Salida = Salida.append("Error\n");
                break;
            }
            case 128: {
                Salida = Salida.append("Fatal\n");
                break;
            }
            default: {
                Salida = Salida.append("Unknow\n");
            }
        }
        Salida = Salida.append("Message: " + msg.getMessaje() + "\n");
        Salida = Salida.append("------------------------------------------------------\n");
        return Salida.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean LChangedFileBaseName;
        long LocLastCreateFileTime;
        long RotFSThr;
        long RotFTThr;
        boolean LEjecutar;
        FileManager Archivo = null;
        String ArchName = null;
        MessageLog Mensaje = null;
        ArchName = this.getCanonicalFileBase();
        rwl.readLock().lock();
        try {
            LEjecutar = this.Ejecutar;
            RotFTThr = this.RotateFileTimeThreshold;
            RotFSThr = this.RotateFileSizeThreshold;
            LocLastCreateFileTime = this.LastCreateFileTime;
            LChangedFileBaseName = this.ChangedFileBaseName;
        }
        finally {
            rwl.readLock().unlock();
        }
        int RemainMsg = 1;
        while (LEjecutar || RemainMsg > 0) {
            rwl.readLock().lock();
            try {
                Mensaje = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                RemainMsg = this.queue.size();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(instance.getClass().getName()).log(Level.SEVERE, ex.getLocalizedMessage());
            }
            finally {
                rwl.readLock().unlock();
            }
            if (Mensaje != null) {
                Calendar rightNow = Calendar.getInstance();
                if (Archivo != null && Math.abs(rightNow.getTimeInMillis() - LocLastCreateFileTime) > RotFTThr) {
                    try {
                        Archivo.Close();
                    }
                    catch (UtilsException ex) {
                        Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    do {
                        if (!(Archivo = new FileManager(ArchName + "-" + this.dateFormat.format(rightNow.getTime()) + ".log")).Exists()) continue;
                        try {
                            Thread.sleep(1100L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                        rightNow = Calendar.getInstance();
                    } while (Archivo.Exists());
                    rwl.writeLock().lock();
                    try {
                        LocLastCreateFileTime = this.LastCreateFileTime = rightNow.getTimeInMillis();
                    }
                    finally {
                        rwl.writeLock().unlock();
                    }
                    try {
                        Archivo.Open(1);
                    }
                    catch (UtilsException ex) {
                        Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.VerifyFilesToKeep();
                } else if (Archivo != null && Archivo.getFileLength() > RotFSThr) {
                    try {
                        Archivo.Close();
                    }
                    catch (UtilsException ex) {
                        Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    do {
                        if (!(Archivo = new FileManager(ArchName + "-" + this.dateFormat.format(rightNow.getTime()) + ".log")).Exists()) continue;
                        try {
                            Thread.sleep(1100L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                    } while (Archivo.Exists());
                    rwl.writeLock().lock();
                    try {
                        LocLastCreateFileTime = this.LastCreateFileTime = rightNow.getTimeInMillis();
                    }
                    finally {
                        rwl.writeLock().unlock();
                    }
                    try {
                        Archivo.Open(1);
                    }
                    catch (UtilsException ex) {
                        Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.VerifyFilesToKeep();
                } else if (Archivo == null) {
                    do {
                        if (!(Archivo = new FileManager(ArchName + "-" + this.dateFormat.format(rightNow.getTime()) + ".log")).Exists()) continue;
                        try {
                            Thread.sleep(1100L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                        }
                        rightNow = Calendar.getInstance();
                    } while (Archivo.Exists());
                    rwl.writeLock().lock();
                    try {
                        LocLastCreateFileTime = this.LastCreateFileTime = rightNow.getTimeInMillis();
                    }
                    finally {
                        rwl.writeLock().unlock();
                    }
                    try {
                        Archivo.Open(1);
                    }
                    catch (UtilsException ex) {
                        Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.VerifyFilesToKeep();
                }
                String MsgFrmtd = this.FormatMessage(Mensaje);
                try {
                    Archivo.Write(MsgFrmtd.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (UtilsException ex) {
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                try {
                    Thread.sleep(this.Random.nextInt(500));
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, ex.getMessage());
                }
            }
            rwl.readLock().lock();
            try {
                LEjecutar = this.Ejecutar;
                RotFTThr = this.RotateFileTimeThreshold;
                RotFSThr = this.RotateFileSizeThreshold;
                LChangedFileBaseName = this.ChangedFileBaseName;
            }
            finally {
                rwl.readLock().unlock();
            }
            if (!LChangedFileBaseName) continue;
            ArchName = this.getCanonicalFileBase();
            if (Archivo != null) {
                try {
                    Archivo.Close();
                }
                catch (UtilsException ex) {
                    Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    Archivo.Delete();
                    Archivo = null;
                }
            }
            rwl.writeLock().lock();
            try {
                LChangedFileBaseName = this.ChangedFileBaseName = false;
            }
            finally {
                rwl.writeLock().unlock();
            }
        }
        if (Archivo != null) {
            try {
                Archivo.Close();
            }
            catch (UtilsException ex) {
                Logger.getLogger(FileLogger.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        FileLogger fileLogger = this;
        synchronized (fileLogger) {
            this.Finalizado = true;
        }
    }

    private class MessageLog {
        private int Type;
        private int Level;
        private String Unit;
        private String Messaje;
        private String TimeStamp;

        public MessageLog(int Type2, int Level2, String Unit, String TimeStamp, String Messaje) {
            this.Type = Type2;
            this.Level = Level2;
            this.Unit = Unit;
            this.TimeStamp = TimeStamp;
            this.Messaje = Messaje;
        }

        public int getType() {
            return this.Type;
        }

        public int getLevel() {
            return this.Level;
        }

        public String getUnit() {
            return this.Unit;
        }

        public String getMessaje() {
            return this.Messaje;
        }

        public String getTimeStamp() {
            return this.TimeStamp;
        }
    }
}

