/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.fec.reedsolomon;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.fec.reedsolomon.GenericGF;
import com.valhalanetworks.utils.fec.reedsolomon.GenericGFPoly;

public strictfp final class ReedSolomonDecoder {
    private final GenericGF field;

    protected ReedSolomonDecoder(GenericGF GField) {
        if (!GenericGF.QR_CODE_FIELD_256.equals(GField)) {
            throw new IllegalArgumentException("Only QR Code is supported at this time");
        }
        this.field = GField;
    }

    protected byte[] decode(byte[] Input, int ErrorCorrectionBytes) throws UtilsException {
        int i;
        int[] received = new int[Input.length];
        for (i = 0; i < received.length; ++i) {
            received[i] = Input[i] & 0xFF;
        }
        GenericGFPoly poly = new GenericGFPoly(this.field, received);
        int[] syndromeCoefficients = new int[ErrorCorrectionBytes];
        boolean dataMatrix = this.field.equals(GenericGF.DATA_MATRIX_FIELD_256);
        boolean noError = true;
        for (i = 0; i < ErrorCorrectionBytes; ++i) {
            int eval;
            syndromeCoefficients[syndromeCoefficients.length - 1 - i] = eval = poly.evaluateAt(this.field.exp(dataMatrix ? i + 1 : i));
            if (eval == 0) continue;
            noError = false;
        }
        byte[] Output = null;
        if (noError) {
            Output = new byte[Input.length - ErrorCorrectionBytes];
            ArrayUtils.arrayCopy(Input, 0, Output, 0, Input.length - ErrorCorrectionBytes);
        } else {
            GenericGFPoly syndrome = new GenericGFPoly(this.field, syndromeCoefficients);
            GenericGFPoly[] sigmaOmega = this.runEuclideanAlgorithm(this.field.buildMonomial(ErrorCorrectionBytes, 1), syndrome, ErrorCorrectionBytes);
            GenericGFPoly sigma = sigmaOmega[0];
            GenericGFPoly omega = sigmaOmega[1];
            int[] errorLocations = this.findErrorLocations(sigma);
            int[] errorMagnitudes = this.findErrorMagnitudes(omega, errorLocations, dataMatrix);
            for (i = 0; i < errorLocations.length; ++i) {
                int position = received.length - 1 - this.field.log(errorLocations[i]);
                if (position < 0) {
                    throw new UtilsException("Bad error location");
                }
                received[position] = GenericGF.addOrSubtract(received[position], errorMagnitudes[i]);
            }
            Output = Converter.int2byte(received);
            for (i = 0; i < Output.length / 4; ++i) {
                Output[i] = Output[3 + i * 4];
            }
            Output = (byte[])ArrayUtils.resizeArray(Output, Output.length / 4 - ErrorCorrectionBytes);
        }
        return Output;
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly a, GenericGFPoly b, int R) throws UtilsException {
        if (a.getDegree() < b.getDegree()) {
            GenericGFPoly temp = a;
            a = b;
            b = temp;
        }
        GenericGFPoly rLast = a;
        GenericGFPoly r = b;
        GenericGFPoly sLast = this.field.getOne();
        GenericGFPoly s = this.field.getZero();
        GenericGFPoly tLast = this.field.getZero();
        GenericGFPoly t = this.field.getOne();
        while (r.getDegree() >= R / 2) {
            GenericGFPoly rLastLast = rLast;
            GenericGFPoly sLastLast = sLast;
            GenericGFPoly tLastLast = tLast;
            rLast = r;
            sLast = s;
            tLast = t;
            if (rLast.isZero()) {
                throw new UtilsException("r_{i-1} was zero");
            }
            r = rLastLast;
            GenericGFPoly q = this.field.getZero();
            int denominatorLeadingTerm = rLast.getCoefficient(rLast.getDegree());
            int dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r.getDegree() >= rLast.getDegree() && !r.isZero()) {
                int degreeDiff = r.getDegree() - rLast.getDegree();
                int scale = this.field.multiply(r.getCoefficient(r.getDegree()), dltInverse);
                q = q.addOrSubtract(this.field.buildMonomial(degreeDiff, scale));
                r = r.addOrSubtract(rLast.multiplyByMonomial(degreeDiff, scale));
            }
            s = q.multiply(sLast).addOrSubtract(sLastLast);
            t = q.multiply(tLast).addOrSubtract(tLastLast);
        }
        int sigmaTildeAtZero = t.getCoefficient(0);
        if (sigmaTildeAtZero == 0) {
            throw new UtilsException("sigmaTilde(0) was zero");
        }
        int inverse = this.field.inverse(sigmaTildeAtZero);
        GenericGFPoly sigma = t.multiply(inverse);
        GenericGFPoly omega = r.multiply(inverse);
        return new GenericGFPoly[]{sigma, omega};
    }

    private int[] findErrorLocations(GenericGFPoly errorLocator) throws UtilsException {
        int numErrors = errorLocator.getDegree();
        if (numErrors == 1) {
            return new int[]{errorLocator.getCoefficient(1)};
        }
        int[] result = new int[numErrors];
        int e = 0;
        for (int i = 1; i < this.field.getSize() && e < numErrors; ++i) {
            if (errorLocator.evaluateAt(i) != 0) continue;
            result[e] = this.field.inverse(i);
            ++e;
        }
        if (e != numErrors) {
            throw new UtilsException("Error locator degree does not match number of roots");
        }
        return result;
    }

    private int[] findErrorMagnitudes(GenericGFPoly errorEvaluator, int[] errorLocations, boolean dataMatrix) {
        int s = errorLocations.length;
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            int xiInverse = this.field.inverse(errorLocations[i]);
            int denominator = 1;
            for (int j = 0; j < s; ++j) {
                if (i == j) continue;
                int term = this.field.multiply(errorLocations[j], xiInverse);
                int termPlus1 = (term & 1) == 0 ? term | 1 : term & 0xFFFFFFFE;
                denominator = this.field.multiply(denominator, termPlus1);
            }
            result[i] = this.field.multiply(errorEvaluator.evaluateAt(xiInverse), this.field.inverse(denominator));
            if (!dataMatrix) continue;
            result[i] = this.field.multiply(result[i], xiInverse);
        }
        return result;
    }
}

